/*
 * IPVS         application module
 *
 * Version:     $Id: ip_vs_app.c,v 1.1.1.1 2000/05/17 07:55:57 wensong Exp $
 *
 * Authors:     
 *
 *              This program is free software; you can redistribute it and/or
 *              modify it under the terms of the GNU General Public License
 *              as published by the Free Software Foundation; either version
 *              2 of the License, or (at your option) any later version.
 *
 * Most code here are taken from ip_masq_app.c in kernel 2.2.
 */

#if 0

#ifdef MODULE
#define EXPORT_SYMTAB
#endif

#endif

#include <linux/config.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/skbuff.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/init.h>
#include <net/protocol.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <asm/system.h>
#include <linux/stat.h>
#include <linux/proc_fs.h>

#include "ip_vs.h"
//#include <net/ip_vs.h>

#define IP_VS_APP_TAB_SIZE  16 /* must be power of 2 */

#define IP_VS_APP_HASH(proto, port) ((port^proto) & (IP_VS_APP_TAB_SIZE-1))
#define IP_VS_APP_TYPE(proto, port) ( proto<<16 | port )
#define IP_VS_APP_PORT(type)        ( type & 0xffff )
#define IP_VS_APP_PROTO(type)       ( (type>>16) & 0x00ff )


#if 0
EXPORT_SYMBOL(register_ip_vs_app);
EXPORT_SYMBOL(unregister_ip_vs_app);
EXPORT_SYMBOL(ip_vs_skb_replace);
#endif



/*
 * FIXME: most of code here needs to be rewritten.
 *        because ip_vs_app module just handle request from outside to inside
 */




/*
 * 	will hold masq app. hashed list heads
 */

struct ip_vs_app *ip_vs_app_base[IP_VS_APP_TAB_SIZE];

/*
 * 	ip_vs_app registration routine
 *	port: host byte order.
 */

int register_ip_vs_app(struct ip_vs_app *vapp,
                       unsigned short proto, __u16 port)
{
        unsigned long flags;
        unsigned hash;
        if (!vapp) {
                IP_VS_ERR("register_ip_vs_app(): NULL arg\n");
                return -EINVAL;
        }
        vapp->type = IP_VS_APP_TYPE(proto, port);
        vapp->n_attach = 0;
        hash = IP_VS_APP_HASH(proto, port);

        save_flags(flags);
        cli();
        vapp->next = ip_vs_app_base[hash];
        ip_vs_app_base[hash] = vapp;
        restore_flags(flags);

        return 0;
}

#if 0000
/*
 * 	ip_vs_app unreg. routine.
 */

int unregister_ip_vs_app(struct ip_vs_app *vapp)
{
        struct ip_vs_app **vapp_p;
        unsigned hash;
        unsigned long flags;
        if (!vapp) {
                IP_VS_ERR("unregister_ip_vs_app(): NULL arg\n");
                return -EINVAL;
        }
        /*
         * only allow unregistration if it has no attachments
         */
        if (vapp->n_attach)  {
                IP_VS_ERR("unregister_ip_vs_app(): has %d attachments. failed\n",
                          vapp->n_attach);
                return -EINVAL;
        }
        hash = IP_VS_APP_HASH(IP_VS_APP_PROTO(vapp->type), IP_MASQ_APP_PORT(vapp->type));

        save_flags(flags);
        cli();
        for (vapp_p = &ip_vs_app_base[hash]; *vapp_p ; vapp_p = &(*vapp_p)->next)
                if (vapp == (*vapp_p))  {
                        *vapp_p = vapp->next;
                        restore_flags(flags);
                        return 0;
                }

        restore_flags(flags);
        IP_VS_ERR("unregister_ip_vs_app(proto=%s,port=%u): not hashed!\n",
                  vs_proto_name(IP_VS_APP_PROTO(vapp->type)), IP_VS_APP_PORT(vapp->type));
        return -EINVAL;
}


/*
 *	get ip_vs_app object by its proto and port (net byte order).
 */

struct ip_vs_app * ip_vs_app_get(unsigned short proto, __u16 port)
{
        struct ip_vs_app *vapp;
        unsigned hash;
        unsigned type;

        port = ntohs(port);
        type = IP_VS_APP_TYPE(proto,port);
        hash = IP_VS_APP_HASH(proto,port);
        for(vapp = ip_vs_app_base[hash]; vapp ; vapp = vapp->next) {
                if (type == vapp->type) return vapp;
        }
        return NULL;
}

/*
 *	ip_vs_app object binding related funcs.
 */

/*
 * 	change ip_vs_app object's number of bindings
 */

static __inline__ int ip_vs_app_bind_chg(struct ip_vs_app *vapp, int delta)
{
        unsigned long flags;
        int n_at;
        if (!vapp) return -1;
        save_flags(flags);
        cli();
        n_at = vapp->n_attach + delta;
        if (n_at < 0) {
                restore_flags(flags);
                IP_VS_ERR("ip_vs_app: tried to set n_attach < 0 for (proto=%s,port==%d) ip_vs_app object.\n",
                          vs_proto_name(IP_VS_APP_PROTO(vapp->type)),
                          IP_VS_APP_PORT(vapp->type));
                return -1;
        }
        vapp->n_attach = n_at;
        restore_flags(flags);
        return 0;
}
        
#endif

/*
 *	Bind ip_vs to its ip_vs_app based on proto and dport ALREADY
 *	set in ip_vs struct. Also calls constructor.
 */

struct ip_vs_app * ip_vs_bind_app(struct ip_vs_conn *cp)
{
#if 0000
        struct ip_vs_app * vapp;

	if (cp->protocol != IPPROTO_TCP && cp->protocol != IPPROTO_UDP)
		return NULL;

        vapp = ip_vs_app_get(cp->protocol, cp->dport);


#ifdef CONFIG_IP_MASQUERADE_VS
        if (vapp == NULL)
                /*
                 * check for virtual service.
                 */
                vapp = ip_vs_app_get(cp->protocol, cp->mport);
#endif

        if (vapp != NULL) {
                /*
                 *	don't allow binding if already bound
                 */

                if (cp->app != NULL) {
                        IP_VS_ERR("ip_vs_bind_app() called for already bound object.\n");
                        return cp->app;
                }

                cp->app = vapp;
                if (vapp->masq_init_1) vapp->masq_init_1(vapp, cp);
                ip_vs_app_bind_chg(vapp, +1);
        }
        return vapp;
#endif
        return NULL;
}

/*
 * 	Unbind cp from type object and call cp destructor (does not kfree()).
 */

int ip_vs_unbind_app(struct ip_vs_conn *cp)
{
#if 0000
        struct ip_vs_app * vapp;
        vapp = cp->app;

	if (cp->protocol != IPPROTO_TCP && cp->protocol != IPPROTO_UDP)
		return 0;

        if (vapp != NULL) {
                if (vapp->masq_done_1) vapp->masq_done_1(vapp, cp);
                cp->app = NULL;
                ip_vs_app_bind_chg(vapp, -1);
        }
        return (vapp != NULL);
#endif
        return 0;
}


#if 0000
/*
 *	Fixes th->seq based on ip_vs_seq info.
 */
static __inline__ void masq_fix_seq(const struct ip_vs_seq *cp_seq, struct tcphdr *th)
{
        __u32 seq;

        seq = ntohl(th->seq);

	/*
	 * 	Adjust seq with delta-offset for all packets after
         * 	the most recent resized pkt seq and with previous_delta offset
         *	for all packets	before most recent resized pkt seq.
	 */
	if (cp_seq->delta || cp_seq->previous_delta) {
		if(after(seq,cp_seq->init_seq) ) {
			th->seq = htonl(seq + cp_seq->delta);
			IP_VS_DEBUG(1, "masq_fix_seq() : added delta (%d) to seq\n",cp_seq->delta);
		} else {
			th->seq = htonl(seq + cp_seq->previous_delta);
			IP_VS_DEBUG(1, "masq_fix_seq() : added previous_delta (%d) to seq\n",cp_seq->previous_delta);
		}
	}


}

/*
 *	Fixes th->ack_seq based on ip_vs_seq info.
 */

static __inline__ void masq_fix_ack_seq(const struct ip_vs_seq *cp_seq, struct tcphdr *th)
{
        __u32 ack_seq;

        ack_seq=ntohl(th->ack_seq);

        /*
         * Adjust ack_seq with delta-offset for
         * the packets AFTER most recent resized pkt has caused a shift
         * for packets before most recent resized pkt, use previous_delta
         */

        if (cp_seq->delta || cp_seq->previous_delta) {
                if(after(ack_seq,cp_seq->init_seq)) {
                        th->ack_seq = htonl(ack_seq-cp_seq->delta);
                        IP_VS_DEBUG(1, "masq_fix_ack_seq() : subtracted delta (%d) from ack_seq\n",cp_seq->delta);

                } else {
                        th->ack_seq = htonl(ack_seq-cp_seq->previous_delta);
                        IP_VS_DEBUG(1, "masq_fix_ack_seq() : subtracted previous_delta (%d) from ack_seq\n",cp_seq->previous_delta);
                }
        }

}

/*
 *	Updates ip_vs_seq if pkt has been resized
 *	Assumes already checked proto==IPPROTO_TCP and diff!=0.
 */

static __inline__ void masq_seq_update(struct ip_vs_conn *cp, struct ip_vs_seq *cp_seq, unsigned mflag, __u32 seq, int diff)
{
        /* if (diff == 0) return; */

        if ( !(cp->flags & mflag) || after(seq, cp_seq->init_seq))
        {
                cp_seq->previous_delta=cp_seq->delta;
                cp_seq->delta+=diff;
                cp_seq->init_seq=seq;
                cp->flags |= mflag;
        }
}

#endif

/*
 *	Output pkt hook. Will call bound ip_vs_app specific function
 *	called by ip_fw_masquerade(), assumes previously checked cp!=NULL
 *	returns (new - old) skb->len diff.
 */

int ip_vs_app_pkt_out(struct ip_vs_conn *cp, struct sk_buff **skb_p)
{
#if 0000
        struct ip_vs_app * vapp;
        struct iphdr *iph;
	struct tcphdr *th;
        int diff;
        __u32 seq;

        /*
         *	check if application masquerading is bound to
         *	this ip_vs.
         *	assumes that once an ip_vs is bound,
         *	it will not be unbound during its life.
         */

        if ( (vapp = cp->app) == NULL)
                return 0;

        iph = (*skb_p)->nh.iph;
        th = (struct tcphdr *)&(((char *)iph)[iph->ihl*4]);

        /*
         *	Remember seq number in case this pkt gets resized
         */

        seq = ntohl(th->seq);

        /*
         *	Fix seq stuff if flagged as so.
         */

        if (cp->protocol == IPPROTO_TCP) {
                if (cp->flags & IP_VS_F_OUT_SEQ)
                        masq_fix_seq(&cp->out_seq, th);
                if (cp->flags & IP_VS_F_IN_SEQ)
                        masq_fix_ack_seq(&cp->in_seq, th);
        }

        /*
         *	Call private output hook function
         */

        if ( vapp->pkt_out == NULL )
                return 0;

        diff = vapp->pkt_out(vapp, cp, skb_p, maddr);

        /*
         *	Update ip_vs seq stuff if len has changed.
         */

        if (diff != 0 && cp->protocol == IPPROTO_TCP)
                masq_seq_update(cp, &cp->out_seq, IP_VS_F_OUT_SEQ, seq, diff);

        return diff;
#endif
        return 0;
}

/*
 *	Input pkt hook. Will call bound ip_vs_app specific function
 *	called by ip_fw_demasquerade(), assumes previously checked cp!=NULL.
 *	returns (new - old) skb->len diff.
 */

int ip_vs_app_pkt_in(struct ip_vs_conn *cp, struct sk_buff **skb_p)
{
#if 0000
        struct ip_vs_app * vapp;
        struct iphdr *iph;
	struct tcphdr *th;
        int diff;
        __u32 seq;

        /*
         *	check if application masquerading is bound to
         *	this ip_vs.
         *	assumes that once an ip_vs is bound,
         *	it will not be unbound during its life.
         */

        if ( (vapp = cp->app) == NULL)
                return 0;

        iph = (*skb_p)->nh.iph;
        th = (struct tcphdr *)&(((char *)iph)[iph->ihl*4]);

        /*
         *	Remember seq number in case this pkt gets resized
         */

        seq = ntohl(th->seq);

        /*
         *	Fix seq stuff if flagged as so.
         */

        if (cp->protocol == IPPROTO_TCP) {
                if (cp->flags & IP_VS_F_IN_SEQ)
                        masq_fix_seq(&cp->in_seq, th);
                if (cp->flags & IP_VS_F_OUT_SEQ)
                        masq_fix_ack_seq(&cp->out_seq, th);
        }

        /*
         *	Call private input hook function
         */

        if ( vapp->pkt_in == NULL )
                return 0;

        diff = vapp->pkt_in(vapp, cp, skb_p, maddr);

        /*
         *	Update ip_vs seq stuff if len has changed.
         */

        if (diff != 0 && cp->protocol == IPPROTO_TCP)
                masq_seq_update(cp, &cp->in_seq, IP_VS_F_IN_SEQ, seq, diff);

        return diff;
#endif
        return 0;
}

/*
 *	/proc/ip_vs_app entry function
 */

int ip_vs_app_getinfo(char *buffer, char **start, off_t offset, int length)
{
        off_t pos=0, begin=0;
        int len=0;
/*          struct ip_vs_app * vapp; */
/*          unsigned idx; */

	if (offset < 40)
		len=sprintf(buffer, "%-39s\n", "prot port    n_attach name");
	pos = 40;

#if 0000
        for (idx=0 ; idx < IP_VS_APP_TAB_SIZE; idx++)
                for (vapp = ip_vs_app_base[idx]; vapp ; vapp = vapp->next) {
			/*
			 * If you change the length of this sprintf, then all
			 * the length calculations need fixing too!
			 * Line length = 40 (3 + 2 + 7 + 1 + 7 + 1 + 2 + 17)
			 */
			pos += 40;
			if (pos < offset)
				continue;

                        len += sprintf(buffer+len, "%-3s  %-7u %-7d  %-17s\n",
                                       vs_proto_name(IP_VS_APP_PROTO(vapp->type)),
                                       IP_VS_APP_PORT(vapp->type), vapp->n_attach,
				       vapp->name);

                        if(len >= length)
                                goto done;
                }
  done:


#endif
        
        begin = len - (pos - offset);
        *start = buffer + begin;
        len -= begin;
        if (len > length)
                len = length;
        return len;
}


/*
 *	Replace a segment (of skb->data) with a new one.
 *	FIXME: Should re-use same skb if space available, this could
 *	       be done if n_len < o_len, unless some extra space
 *	       were already allocated at driver level :P .
 */

static struct sk_buff * skb_replace(struct sk_buff *skb, int pri, char *o_buf, int o_len, char *n_buf, int n_len)
{
        int maxsize, diff, o_offset;
        struct sk_buff *n_skb;
	int offset;

	maxsize = skb->truesize;

        diff = n_len - o_len;
        o_offset = o_buf - (char*) skb->data;

	if (maxsize <= n_len) {
	    if (diff != 0) {
		memcpy(skb->data + o_offset + n_len,o_buf + o_len,
		       skb->len - (o_offset + o_len));
	    }

	    memcpy(skb->data + o_offset, n_buf, n_len);

	    n_skb    = skb;
	    skb->len = n_len;
	    skb->end = skb->head+n_len;
	} else {
                /*
                 * 	Sizes differ, make a copy.
                 *
                 *	FIXME: move this to core/sbuff.c:skb_grow()
                 */

                n_skb = alloc_skb(MAX_HEADER + skb->len + diff, pri);
                if (n_skb == NULL) {
                        IP_VS_ERR("skb_replace(): no room left (from %p)\n",
                               __builtin_return_address(0));
                        return skb;

                }
                skb_reserve(n_skb, MAX_HEADER);
                skb_put(n_skb, skb->len + diff);

                /*
                 *	Copy as much data from the old skb as possible. Even
                 *	though we're only forwarding packets, we need stuff
                 *	like skb->protocol (PPP driver wants it).
                 */
                offset = n_skb->data - skb->data;
                n_skb->nh.raw = skb->nh.raw + offset;
                n_skb->h.raw = skb->h.raw + offset;
                n_skb->dev = skb->dev;
                n_skb->mac.raw = skb->mac.raw + offset;
                n_skb->pkt_type = skb->pkt_type;
                n_skb->protocol = skb->protocol;
                n_skb->ip_summed = skb->ip_summed;
		n_skb->dst = dst_clone(skb->dst);

                /*
                 * Copy pkt in new buffer
                 */
                memcpy(n_skb->data, skb->data, o_offset);
                memcpy(n_skb->data + o_offset, n_buf, n_len);
                memcpy(n_skb->data + o_offset + n_len, o_buf + o_len,
                       skb->len - (o_offset + o_len) );

                /*
                 * Problem, how to replace the new skb with old one,
                 * preferably inplace
                 */
                kfree_skb(skb);
        }
        return n_skb;
}


/*
 *	calls skb_replace() and update ip header if new skb was allocated
 */
struct sk_buff * ip_vs_skb_replace(struct sk_buff *skb, int pri, char *o_buf, int o_len, char *n_buf, int n_len)
{
        int diff;
        struct sk_buff *n_skb;
        unsigned skb_len;

        diff = n_len - o_len;
        n_skb = skb_replace(skb, pri, o_buf, o_len, n_buf, n_len);
        skb_len = skb->len;

        if (diff)
        {
                struct iphdr *iph;
                IP_VS_DBG(1, "pkt resized for %d bytes (len=%d)\n",
                          diff, skb->len);
                /*
                 * 	update ip header
                 */
                iph = n_skb->nh.iph;
                iph->check = 0;
                iph->check = ip_fast_csum((unsigned char *)iph, iph->ihl);
                iph->tot_len = htons(skb_len + diff);
        }
        return n_skb;
}


int ip_vs_app_init(void)
{
        /* we will replace it with proc_net_ipvs_create() soon */
	proc_net_create("ip_vs_app", 0, ip_vs_app_getinfo);
        return 0;
}

void ip_vs_app_cleanup(void)
{
        proc_net_remove("ip_vs_app");
}
